<?php
defined('BASEPATH') or exit('No direct script access allowed');

class M_catalogue extends CI_Model
{
    public function get_data($columns, $start, $length, $search_value = null, $order_column = null, $order_dir = null)
    {
        $this->db->select($columns);
        $this->db->from('tb_catalog');

        if ($search_value) {
            $this->db->group_start();
            foreach ($columns as $column) {
                $this->db->or_like($column, $search_value);
            }
            $this->db->group_end();
        }

        if ($order_column && $order_dir) {
            $this->db->order_by($columns[$order_column], $order_dir);
        }

        $this->db->limit($length, $start);

        $query = $this->db->get();
        return $query->result();
    }

    public function count_filtered_data($columns, $search_value = null)
    {
        $this->db->select('COUNT(*) as count');
        $this->db->from('tb_catalog');

        if ($search_value) {
            $this->db->group_start();
            foreach ($columns as $column) {
                $this->db->or_like($column, $search_value);
            }
            $this->db->group_end();
        }

        $query = $this->db->get();
        return $query->row()->count;
    }

    public function count_all_data()
    {
        return $this->db->count_all('tb_catalog');
    }
}
