<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Catalogue extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('m_catalogue');
    }

    private function _sendEmail($alamatEmail)
    {
    }

    public function index()
    {

        $this->form_validation->set_rules('nama', 'Nama', 'trim|required|min_length[5]', [
            'min_length' => " Nama anda terlalu pendek"
        ]);
        $this->form_validation->set_rules('whatsapp', 'No. Whatsapp', 'trim|required|min_length[8]', [
            'min_length' => " Nomor Whatsapp terlalu pendek"
        ]);
        $this->form_validation->set_rules('email', 'E-Mail', 'trim|required|valid_email', [
            'valid_email' => ' Format E-mail tidak benar'
        ]);

        if ($this->form_validation->run() == FALSE) {
            # code...
            $data['produk']     = $this->db->get('tb_catalog');
            $this->load->view('catalog/index', $data);
        } else {
            # code...
            $nama   = $this->input->post('nama');
            $wa     = $this->input->post('whatsapp');
            $email  = $this->input->post('email');

            $data = [
                'nama'      => $nama,
                'whatsapp'  => $wa,
                'email'     => $email,
                'dateDownload'  => time()
            ];

            if ($this->db->insert('tb_catalog_download', $data)) {
                // redirect('https://member.foodpack.co.id/download');
                $this->session->set_flashdata('message', '<div id="alertSuccess" class="alert alert-success" role="alert">Terimaksih sudah mendownload Catalog Foodpack Indonesia!</div>');
                $this->session->set_flashdata(
                    'notif',
                    '<script>window.open("https://member.foodpack.co.id/download", "_blank");</script>'
                );
                redirect('catalogue');
            }
        }
    }

    public function get_data()
    {
        $columns = array(
            0 => 'cat_code',
            1 => 'model',
            2 => 'Deskripsi',
            3 => 'image_name',
            4 => 'kategori'
            // tambahkan kolom lainnya sesuai kebutuhan
        );

        $length         = $this->input->post('length');
        $start          = $this->input->post('start');
        $search_value   = isset($_POST['search']['value']) ? $this->input->post('search')['value'] : '';
        $order_column   = isset($_POST['order'][0]['column']) ? $this->input->post('order')[0]['column'] : null;
        $order_dir      = isset($_POST['order'][0]['dir']) ? $this->input->post('order')[0]['dir'] : null;

        $total_data     = $this->m_catalogue->count_all_data();
        $filtered_data  = $this->m_catalogue->count_filtered_data($columns, $search_value);
        $data           = $this->m_catalogue->get_data($columns, $start, $length, $search_value, $order_column, $order_dir);

        $response = array(
            "draw" => intval($this->input->post('draw')),
            "recordsTotal" => $total_data,
            "recordsFiltered" => $filtered_data,
            "data" => $data
        );

        echo json_encode($response);
    }
}
