<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="<?= base_url('assets/images'); ?>/favicon.png">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>FoodPack E-Catalog</title>

    <link rel="stylesheet" href="<?= base_url('node_modules') ?>/bootstrap/dist/css/bootstrap.min.css">
    <link href="<?= base_url('assets/') ?>font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="<?= base_url('assets/') ?>css/animate.css" rel="stylesheet">
    <link href="<?= base_url('assets/') ?>css/style.css" rel="stylesheet">
    <!-- data tables -->
    <link href="https://cdn.datatables.net/v/bs5/dt-1.13.10/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/fc-4.3.0/r-2.5.0/rg-1.4.1/rr-1.4.1/sc-2.3.0/sb-1.6.0/sp-2.2.0/datatables.min.css" rel="stylesheet">
</head>

<body class="top-navigation" id="page-top">
    <style>
        .td {
            width: 100%;
            height: 100%;
            padding: 5px;
            /* Anda dapat menyesuaikan padding sesuai kebutuhan */
            box-sizing: border-box;
            /* Pastikan padding dihitung dalam lebar dan tinggi */
        }

        #wrapper nav a {
            text-decoration: none;
        }

        ul .float-end {
            position: absolute;
            right: 0;
        }

        #navbar UL {
            position: absolute;
            right: 0;
        }

        ul.pagination.active {
            /* color: #f44336; */
            background-color: #f44336;
        }

        #navbar a:hover {
            color: #ffffff !important;
            background-color: #f44336;
        }

        .ibox {
            width: 100%;
            /* Atur lebar sesuai kebutuhan */
            height: 200px;
            /* Atur tinggi sesuai kebutuhan */
        }

        .ibox {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            /* Atur cara elemen diatur di dalam flex container */
            align-items: center;
            /* Atur cara elemen diatur di dalam flex container */
            width: 100%;
            /* Atur lebar sesuai kebutuhan */
            height: auto;
            /* Atur tinggi sesuai kebutuhan */
        }
    </style>
    <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
            <div class="wrapper wrapper-content">
                <div class="row border-bottom red-bg page-heading rounded mb-2">
                    <div class="col-sm-4">
                        <h2>Katalog Produk</h2>
                        <span>Daftar produk yang tersedia di foodpack.co.id</span>
                    </div>
                    <div class="col-sm-8">
                        <div class="title-action">
                            <div class="btn-group shadow">
                                <button class="btn btn-sm btn-primary whatsapp" id="whatsapp"><i class="fa fa-brands fa-whatsapp"></i></button>
                                <button class="btn btn-sm btn-dark tiktok" id="tiktok"><i class="fa fa-brands fa-tiktok"></i></button>
                                <button class="btn btn-sm instagram" style="background-color: #E1306C; color:#ffffff;" id="instagram"><i class="fa fa-brands fa-instagram"></i></button>
                            </div>
                            <button class="btn btn-sm btn-success" id="download"><i class="fa fa-download"></i> Unduh</button>
                        </div>
                    </div>
                </div>
                <!-- <div class="wrapper wrapper-content"> -->
                <?= $this->session->flashdata('message'); ?>
                <?= form_error('nama', '<div id="alertNama" class="alert alert-danger alert-dismissible d-flex align-items-center fade show" role="alert"><i class="fa-solid fa-triangle-exclamation"></i> <div> ', '</div> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>'); ?>
                <?= form_error('whatsapp', '<div id="alertWhatsapp" class="alert alert-danger alert-dismissible d-flex align-items-center fade show" role="alert"><i class="fa-solid fa-triangle-exclamation"></i> <div> ', '</div> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>'); ?>
                <?= form_error('email', '<div id="alertEmail" class="alert alert-danger alert-dismissible d-flex align-items-center fade show" role="alert"><i class="fa-solid fa-triangle-exclamation"></i> <div> ', '</div> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>'); ?>
                <div class="card mt-2">
                    <div class="card-body">
                        <table id="tb_catalog" style="border: 0; border-collapse:collapse" class="table-responsive" width="100%">
                            <thead>
                                <tr>
                                    <th>Model</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
            <div class="landing-page">
                <section class="gray-section contact">
                    <!-- <div class="container"> -->
                    <div class="row m-b-lg">
                        <div class="col-lg-12 text-center">
                            <div class="navy-line"></div>
                            <h1>Contact Us</h1>
                            <p></p>
                        </div>
                    </div>
                    <div class="row m-b-lg justify-content-center">
                        <div class="col-lg-3 ">
                            <address>
                                <strong><span class="navy">FoodPack Indonesia</span></strong><br />
                                Jl. Garuda 75-77<br />
                                Bandung <br />
                                Jawa-Barat<br />
                                <abbr title="Phone">Phone:</abbr> (+62) 878-2785-1394
                            </address>
                        </div>
                        <div class="col-lg-4">
                            <p class="text-color">
                                Foodpack is a world class manufacturer of specialty plastic food container for hotel, restaurant, cafe, catering. We take great pride in producing custom, innovative solutions that are designed to meet the needs of our clients while providing excellent customer service and support.
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 text-center">
                            <p class="m-t-sm">
                                Hubungi kami lewat sosial media dibawah ini
                            </p>
                            <ul class="list-inline social-icon">
                                <li class="list-inline-item"><a href="#" class="whatsapp bg-primary"><i class="fa fa-brands fa-whatsapp"></i></a>
                                </li>
                                <li class="list-inline-item"><a href="#" class="instagram" style="background-color: #E1306C; color:#ffffff;"><i class="fa fa-instagram"></i></a>
                                </li>
                                <li class="list-inline-item"><a href="#" class="tiktok bg-dark"><i class="fa fa-brands fa-tiktok"></i></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 text-center m-t-lg m-b-lg">
                            <p><strong>&copy; <?= date('Y') ?> foodpack.co.id</strong><br />
                                We have a specialized team, who can help to make a choice appropriate to your need.</p>
                        </div>
                    </div>
                    <!-- </div> -->
                </section>
            </div>
        </div>
    </div>
    <!-- /#wrapper -->
    <!-- modal window -->
    <div class="modal inmodal" id="formDownload" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content animated bounceInRight">
                <div class="modal-header">
                    <!-- <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button> -->
                    <i class="fa fa-laptop modal-icon"></i>
                    <h4 class="modal-title">Form Download</h4>
                    <small class="font-bold">Isi form terlebih dahulu, file katalog akan otomatis terunduh</small>
                </div>
                <form action="<?= base_url('catalogue/') ?>" method="POST" class="form-inline">
                    <div class="modal-body">
                        <div class="form-floating mb-3">
                            <input type="text" name="nama" id="nama" class="form-control" placeholder="Nama lengkap">
                            <label for="nama">Nama Lengkap</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="text" name="whatsapp" id="whatsapp" class="form-control" placeholder="Whatsapp">
                            <label for="whatsapp">Whatsapp</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="text" name="email" id="email" class="form-control" placeholder="E-mail">
                            <label for="nama">E-mail</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white close" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Download</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="<?= base_url('assets/') ?>js/jquery-3.1.1.min.js"></script>
    <script src="<?= base_url('assets/') ?>js/popper.min.js"></script>
    <script src="<?= base_url('assets/') ?>js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="<?= base_url('assets/') ?>js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    <!-- Custom and plugin javascript -->
    <script src="<?= base_url('assets/') ?>js/inspinia.js"></script>
    <script src="<?= base_url('assets/') ?>js/plugins/pace/pace.min.js"></script>
    <!-- datatables -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/v/bs5/dt-1.13.10/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/fc-4.3.0/r-2.5.0/rg-1.4.1/rr-1.4.1/sc-2.3.0/sb-1.6.0/sp-2.2.0/datatables.min.js"></script>
    <!-- Flot -->
    <script src="<?= base_url('assets/') ?>js/plugins/flot/jquery.flot.js"></script>
    <script src="<?= base_url('assets/') ?>js/plugins/flot/jquery.flot.tooltip.min.js"></script>
    <script src="<?= base_url('assets/') ?>js/plugins/flot/jquery.flot.resize.js"></script>
    <!-- ChartJS-->
    <script src="<?= base_url('assets/') ?>js/plugins/chartJs/Chart.min.js"></script>
    <!-- Peity -->
    <script src="<?= base_url('assets/') ?>js/plugins/peity/jquery.peity.min.js"></script>
    <!-- Peity demo -->
    <script src="<?= base_url('assets/') ?>js/demo/peity-demo.js"></script>
    <script src="<?= base_url('node_modules') ?>/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="https://kit.fontawesome.com/0afcaf4d10.js" crossorigin="anonymous"></script>
    <script src="<?= base_url('node_modules') ?>/axios/dist/axios.min.js"></script>
    <script src="<?= base_url('node_modules') ?>/axios/dist/axios.js"></script>
    <?= $this->session->flashdata('notif'); ?>
    <script>
        $(document).ready(function() {
            $(".toform").click(function() {
                window.location.href = "https://member.foodpack.co.id/auth/registration";
            });

            $(".close").click(() => {
                $("#formDownload").modal('hide');
            })

            $("#tb_catalog thead").hide();

            const table = $("#tb_catalog").DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "<?= base_url('catalogue/get_data') ?>",
                    type: 'POST'
                },
                bInfo: false,
                pageLength: 8,
                lengthChange: false,
                deferRender: true,
                processing: true,
                searching: true,
                columns: [{
                    render: function(data, type, row, meta) {
                        const html =
                            '<div class="ibox rounded" style="background-color: #FFFAF0;">' +
                            '<div class="ibox-content product-box" style="overflow: hidden">' +
                            '<div class="product-imitation" style="background-image: url(https://member.foodpack.co.id/assets/img/catalogue/' + row.image_name + '); background-size: cover; background-position: center; background-repeat: no-repeat;">' +
                            '[' + row.model + ']' +
                            '</div>' +
                            '<div class="product-desc">' +
                            '<small class="text-muted">' + row.kategori + '</small>' +
                            '<span href="#" class="product-name">' + row.model + '</span>' +
                            '<div class="small m-t-xs">' + row.Deskripsi + '. </div>' +
                            '<div class="m-t text-righ">' +
                            '<button class="btn btn-sm btn-outline btn-danger detail" data-id="' + row.cat_code + '">Detail <i class="fa fa-long-arrow-right"></i> </button>' +
                            '</div>' +
                            '</div>' +
                            '</div>' +
                            '</div>';

                        return html;
                    }
                }]
            });
            table.on('draw', function(data) {
                $("#tb_catalog tbody").addClass('row');
                $("#tb_catalog tbody tr").addClass('col-md-3 col-6 col-2');
                $("#tb_catalog tbody td").addClass('td');
            });

            $("#tb_catalog tbody").on('click', '.detail', function() {
                const id = $(this).data('id');

            })
        });

        function openLink(url) {
            window.open(url, '_blank');
        }

        $(".whatsapp").click(() => {
            url = "https://wa.me/6287827851394";
            openLink(url);
        });

        $(".tiktok").click(() => {
            url = 'https://www.tiktok.com/@foodpack.official';
            openLink(url);
        })

        $(".instagram").click(function() {
            url = 'https://www.instagram.com/Foodpack.official/';
            openLink(url);
        });

        $("#download").click(() => {
            $("#formDownload").modal('show');
        });

        document.addEventListener("DOMContentLoaded", function() {
            setTimeout(function() {
                $("#alertNama").addClass('d-none');
                $("#alertWhatsapp").addClass('d-none');
                $("#alertEmail").addClass('d-none');
                $("#alertSuccess").addClass('d-none');
            }, 5000)
        })
    </script>
</body>

</html>